/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.ActivatedAbility;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilitySourceEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;

class QuicksilverElementalEffect
extends OneShotEffect {
    QuicksilverElementalEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} gains all activated abilities of target creature until end of turn";
    }

    private QuicksilverElementalEffect(QuicksilverElementalEffect effect) {
        super((OneShotEffect)effect);
    }

    public QuicksilverElementalEffect copy() {
        return new QuicksilverElementalEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Permanent creature = game.getPermanent(source.getTargets().getFirstTarget());
        if (permanent != null && creature != null) {
            for (ActivatedAbility ability : creature.getAbilities().getActivatedAbilities(Zone.BATTLEFIELD)) {
                ActivatedAbility newAbility = ability.copy();
                newAbility.newOriginalId();
                newAbility.getSubAbilities().clear();
                game.addEffect((ContinuousEffect)new GainAbilitySourceEffect((Ability)newAbility, Duration.EndOfTurn), source);
            }
            return true;
        }
        return false;
    }
}

