/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.q;

import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesBasicLandTargetEffect;
import mage.cards.q.LandHasFloodCounterCondition;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;

class QuicksilverFountainEffect
extends OneShotEffect {
    QuicksilverFountainEffect() {
        super(Outcome.Neutral);
        this.staticText = "that player puts a flood counter on target non-Island land they control of their choice. That land is an Island for as long as it has a flood counter on it";
    }

    private QuicksilverFountainEffect(QuicksilverFountainEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(game.getActivePlayerId());
        if (player != null) {
            Permanent landChosen = game.getPermanent(source.getFirstTarget());
            landChosen.addCounters(CounterType.FLOOD.createInstance(), player.getId(), source, game);
            BecomesBasicLandTargetEffect becomesBasicLandTargetEffect = new BecomesBasicLandTargetEffect(Duration.Custom, new SubType[]{SubType.ISLAND});
            ConditionalContinuousEffect effect = new ConditionalContinuousEffect((ContinuousEffect)becomesBasicLandTargetEffect, (Condition)LandHasFloodCounterCondition.instance, this.staticText);
            SimpleStaticAbility gainAbility = new SimpleStaticAbility((Effect)effect);
            gainAbility.setSourceId(landChosen.getId());
            gainAbility.getTargets().add((Target)source.getTargets().get(0));
            game.addEffect((ContinuousEffect)effect, (Ability)gainAbility);
            return true;
        }
        return false;
    }

    public QuicksilverFountainEffect copy() {
        return new QuicksilverFountainEffect(this);
    }
}

