/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class DrawCardsDefendingPlayerEffect
extends OneShotEffect {
    DrawCardsDefendingPlayerEffect() {
        super(Outcome.Benefit);
        this.staticText = "defending player discards all the cards in their hand, then draws that many cards";
    }

    private DrawCardsDefendingPlayerEffect(DrawCardsDefendingPlayerEffect effect) {
        super((OneShotEffect)effect);
    }

    public DrawCardsDefendingPlayerEffect copy() {
        return new DrawCardsDefendingPlayerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player defendingPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller != null && defendingPlayer != null) {
            int numberOfCardsInHand = defendingPlayer.getHand().size();
            defendingPlayer.discard(defendingPlayer.getHand(), false, source, game);
            defendingPlayer.drawCards(numberOfCardsInHand, source, game);
            return true;
        }
        return false;
    }
}

