/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamagePlayersEffect;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;
import mage.watchers.common.ManaSpentToCastWatcher;

class RadiantEpicureEffect
extends OneShotEffect {
    RadiantEpicureEffect() {
        super(Outcome.Benefit);
        this.staticText = "each opponent loses X life and you gain X life, where X is the number of colors of mana spent to cast this spell";
    }

    private RadiantEpicureEffect(RadiantEpicureEffect effect) {
        super((OneShotEffect)effect);
    }

    public RadiantEpicureEffect copy() {
        return new RadiantEpicureEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        ManaSpentToCastWatcher watcher = (ManaSpentToCastWatcher)game.getState().getWatcher(ManaSpentToCastWatcher.class);
        if (player == null || watcher == null) {
            return false;
        }
        Mana payment = watcher.getManaPayment(CardUtil.getSourceStackMomentReference((Game)game, (Ability)source));
        if (payment == null) {
            return false;
        }
        int xValue = payment.getDifferentColors();
        new DamagePlayersEffect(xValue, TargetController.OPPONENT).apply(game, source);
        player.gainLife(xValue, game, source);
        return true;
    }
}

