/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.PayLifeCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.abilities.effects.common.DrawCardSourceControllerEffect;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.DamagedPlayerEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class RaidersSpoilsTriggeredAbility
extends TriggeredAbilityImpl {
    RaidersSpoilsTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DoIfCostPaid((Effect)new DrawCardSourceControllerEffect(1), (Cost)new PayLifeCost(1)), false);
        this.setTriggerPhrase("Whenever a Warrior you control deals combat damage to a player, ");
    }

    private RaidersSpoilsTriggeredAbility(RaidersSpoilsTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RaidersSpoilsTriggeredAbility copy() {
        return new RaidersSpoilsTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        DamagedPlayerEvent damageEvent = (DamagedPlayerEvent)event;
        Permanent permanent = game.getPermanent(event.getSourceId());
        return damageEvent.isCombatDamage() && permanent != null && permanent.hasSubtype(SubType.WARRIOR, game) && permanent.isControlledBy(this.controllerId);
    }
}

