/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.StackObject;
import mage.players.Player;

class RainOfGoreEffect
extends ReplacementEffectImpl {
    RainOfGoreEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a spell or ability would cause its controller to gain life, that player loses that much life instead";
    }

    private RainOfGoreEffect(RainOfGoreEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RainOfGoreEffect copy() {
        return new RainOfGoreEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player player = game.getPlayer(event.getPlayerId());
        if (player != null) {
            player.loseLife(event.getAmount(), game, source, false);
        }
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.GAIN_LIFE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        StackObject stackObject = game.getStack().getFirstOrNull();
        return stackObject != null && stackObject.isControlledBy(event.getPlayerId());
    }
}

