/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.game.stack.StackObject;
import mage.watchers.Watcher;
import mage.watchers.common.ManaPaidSourceWatcher;

class RainOfRichesWatcher
extends Watcher {
    private final Map<UUID, MageObjectReference> playerMap = new HashMap<UUID, MageObjectReference>();

    RainOfRichesWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        if (event.getType() != GameEvent.EventType.SPELL_CAST) {
            return;
        }
        Spell spell = game.getSpell(event.getSourceId());
        if (spell == null) {
            return;
        }
        int manaPaid = ManaPaidSourceWatcher.getTreasurePaid((UUID)spell.getId(), (Game)game);
        if (manaPaid < 1) {
            return;
        }
        this.playerMap.computeIfAbsent(event.getPlayerId(), x -> new MageObjectReference((MageObject)spell.getMainCard(), game));
    }

    public void reset() {
        this.playerMap.clear();
        super.reset();
    }

    boolean checkSpell(StackObject stackObject, Game game) {
        if (stackObject.isCopy() || !(stackObject instanceof Spell)) {
            return false;
        }
        if (this.playerMap.containsKey(stackObject.getControllerId())) {
            return this.playerMap.get(stackObject.getControllerId()).refersTo((MageObject)((Spell)stackObject).getMainCard(), game);
        }
        return ManaPaidSourceWatcher.getTreasurePaid((UUID)stackObject.getId(), (Game)game) >= 1;
    }
}

