/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.OpponentsLostLifeCount;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.abilities.effects.Effect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;

class RakdosLordOfRiotsCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    RakdosLordOfRiotsCantCastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = "You can't cast this spell unless an opponent lost life this turn";
    }

    private RakdosLordOfRiotsCantCastEffect(RakdosLordOfRiotsCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public RakdosLordOfRiotsCantCastEffect copy() {
        return new RakdosLordOfRiotsCantCastEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (event.getSourceId().equals(source.getSourceId())) {
            return OpponentsLostLifeCount.instance.calculate(game, source, (Effect)this) == 0;
        }
        return false;
    }
}

