/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.dynamicvalue.common.OpponentsLostLifeCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.cards.Card;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class RakdosLordOfRiotsCostReductionEffect
extends CostModificationEffectImpl {
    RakdosLordOfRiotsCostReductionEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "Creature spells you cast cost {1} less to cast for each 1 life your opponents have lost this turn";
    }

    private RakdosLordOfRiotsCostReductionEffect(RakdosLordOfRiotsCostReductionEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        Ability spellAbility = abilityToModify;
        if (spellAbility != null) {
            int amount = OpponentsLostLifeCount.instance.calculate(game, source, (Effect)this);
            CardUtil.reduceCost((Ability)spellAbility, (int)amount);
            return true;
        }
        return false;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        Card spellCard;
        if (abilityToModify instanceof SpellAbility && abilityToModify.isControlledBy(source.getControllerId()) && (spellCard = ((SpellAbility)abilityToModify).getCharacteristics(game)) != null) {
            return spellCard.isCreature(game);
        }
        return false;
    }

    public RakdosLordOfRiotsCostReductionEffect copy() {
        return new RakdosLordOfRiotsCostReductionEffect(this);
    }
}

