/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.keyword.FlyingAbility;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RakingCanopyTriggeredAbility
extends TriggeredAbilityImpl {
    public RakingCanopyTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(4));
    }

    private RakingCanopyTriggeredAbility(RakingCanopyTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RakingCanopyTriggeredAbility copy() {
        return new RakingCanopyTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ATTACKER_DECLARED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent attacker = game.getPermanent(event.getSourceId());
        if (attacker == null || !attacker.getAbilities().contains((Ability)FlyingAbility.getInstance())) {
            return false;
        }
        if (event.getTargetId().equals(this.getControllerId())) {
            for (Effect effect : this.getEffects()) {
                effect.setTargetPointer((TargetPointer)new FixedTarget(attacker.getId(), game));
            }
            return true;
        }
        return false;
    }

    public String getRule() {
        return "Whenever a creature with flying attacks you, {this} deals 4 damage to it.";
    }
}

