/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Set;
import java.util.UUID;
import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.r.RalLeylineProdigyCastEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RalLeylineProdigyMinusEightEffect
extends OneShotEffect {
    RalLeylineProdigyMinusEightEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile the top eight cards of your library. You may cast instant and sorcery spells from among them this turn without paying their mana costs";
    }

    private RalLeylineProdigyMinusEightEffect(RalLeylineProdigyMinusEightEffect effect) {
        super((OneShotEffect)effect);
    }

    public RalLeylineProdigyMinusEightEffect copy() {
        return new RalLeylineProdigyMinusEightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (player == null || sourceObject == null) {
            return false;
        }
        Set cards = player.getLibrary().getTopCards(game, 8);
        UUID exileId = CardUtil.getExileZoneId((Game)game, (UUID)source.getSourceId(), (int)source.getStackMomentSourceZCC());
        player.moveCardsToExile(cards, source, game, true, exileId, sourceObject.getIdName());
        for (Card card : cards) {
            if (game.getState().getZone(card.getId()) != Zone.EXILED) continue;
            game.addEffect((ContinuousEffect)new RalLeylineProdigyCastEffect(new MageObjectReference((MageObject)card, game)), source);
        }
        return true;
    }
}

