/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.Target;
import mage.target.common.TargetOpponentOrPlaneswalker;

class RalStormConduitTriggeredAbility
extends TriggeredAbilityImpl {
    RalStormConduitTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new DamageTargetEffect(1), false);
        this.addTarget((Target)new TargetOpponentOrPlaneswalker());
    }

    private RalStormConduitTriggeredAbility(RalStormConduitTriggeredAbility effect) {
        super((TriggeredAbilityImpl)effect);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case COPIED_STACKOBJECT: 
            case SPELL_CAST: {
                return true;
            }
        }
        return false;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpell(event.getTargetId());
        return spell != null && spell.isControlledBy(this.getControllerId()) && spell.isInstantOrSorcery(game);
    }

    public RalStormConduitTriggeredAbility copy() {
        return new RalStormConduitTriggeredAbility(this);
    }

    public String getRule() {
        return "Whenever you cast or copy an instant or sorcery spell, {this} deals 1 damage to target opponent or planeswalker.";
    }
}

