/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.cards.Card;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RallyTheAncestorsEffect
extends OneShotEffect {
    RallyTheAncestorsEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Return each creature card with mana value X or less from your graveyard to the battlefield. Exile those creatures at the beginning of your next upkeep";
    }

    private RallyTheAncestorsEffect(RallyTheAncestorsEffect effect) {
        super((OneShotEffect)effect);
    }

    public RallyTheAncestorsEffect copy() {
        return new RallyTheAncestorsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
            FilterCreatureCard filter = new FilterCreatureCard();
            filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, xValue + 1));
            Set cards = player.getGraveyard().getCards((FilterCard)filter, game);
            player.moveCards(cards, Zone.BATTLEFIELD, source, game);
            ArrayList<Permanent> toExile = new ArrayList<Permanent>(cards.size());
            for (Card card : cards) {
                Permanent permanent;
                if (card == null || (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) == null) continue;
                toExile.add(permanent);
            }
            ExileTargetEffect exileEffect = new ExileTargetEffect("Exile those creatures at the beginning of your next upkeep");
            exileEffect.setTargetPointer((TargetPointer)new FixedTargets(toExile, game));
            AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility delayedAbility = new AtTheBeginOfYourNextUpkeepDelayedTriggeredAbility((Effect)exileEffect);
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)delayedAbility, source);
            return true;
        }
        return false;
    }
}

