/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RallyTheRighteousUntapEffect
extends OneShotEffect {
    RallyTheRighteousUntapEffect() {
        super(Outcome.Untap);
        this.staticText = "<i>Radiance</i> &mdash; Untap target creature and each other creature that shares a color with it";
    }

    private RallyTheRighteousUntapEffect(RallyTheRighteousUntapEffect effect) {
        super((OneShotEffect)effect);
    }

    public RallyTheRighteousUntapEffect copy() {
        return new RallyTheRighteousUntapEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (target != null) {
            ObjectColor color = target.getColor(game);
            target.untap(game);
            for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game)) {
                if (!permanent.getColor(game).shares(color) || permanent.getId().equals(target.getId())) continue;
                permanent.untap(game);
            }
            return true;
        }
        return false;
    }
}

