/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.permanent.SaddledSourceThisTurnPredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class RamblingPossumEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent("creatures that saddled it this turn");

    RamblingPossumEffect() {
        super(Outcome.Benefit);
        this.staticText = "Then you may return any number of creatures that saddled it this turn to their owner's hand";
    }

    private RamblingPossumEffect(RamblingPossumEffect effect) {
        super((OneShotEffect)effect);
    }

    public RamblingPossumEffect copy() {
        return new RamblingPossumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetPermanent target = new TargetPermanent(0, Integer.MAX_VALUE, filter, true);
        player.choose(this.outcome, (Target)target, source, game);
        Set permanents = target.getTargets().stream().map(arg_0 -> ((Game)game).getPermanent(arg_0)).filter(Objects::nonNull).collect(Collectors.toSet());
        return player.moveCards(permanents, Zone.HAND, source, game);
    }

    static {
        filter.add((ObjectSourcePlayerPredicate)SaddledSourceThisTurnPredicate.instance);
    }
}

