/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;
import mage.players.Player;

class RamosDragonEngineAddCountersEffect
extends OneShotEffect {
    RamosDragonEngineAddCountersEffect() {
        super(Outcome.Benefit);
        this.staticText = "put a +1/+1 counter on {this} for each of that spell's colors";
    }

    private RamosDragonEngineAddCountersEffect(RamosDragonEngineAddCountersEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell;
        Player you = game.getPlayer(source.getControllerId());
        Permanent permanent = game.getPermanent(source.getSourceId());
        if (you != null && permanent != null && (spell = game.getSpellOrLKIStack(this.getTargetPointer().getFirst(game, source))) != null) {
            int amount = 0;
            if (spell.getColor(game).isWhite()) {
                ++amount;
            }
            if (spell.getColor(game).isBlue()) {
                ++amount;
            }
            if (spell.getColor(game).isBlack()) {
                ++amount;
            }
            if (spell.getColor(game).isRed()) {
                ++amount;
            }
            if (spell.getColor(game).isGreen()) {
                ++amount;
            }
            if (amount > 0) {
                permanent.addCounters(CounterType.P1P1.createInstance(amount), source.getControllerId(), source, game);
                return true;
            }
        }
        return false;
    }

    public RamosDragonEngineAddCountersEffect copy() {
        return new RamosDragonEngineAddCountersEffect(this);
    }
}

