/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class RampageOfTheValkyriesEffect
extends OneShotEffect {
    RampageOfTheValkyriesEffect() {
        super(Outcome.Benefit);
        this.staticText = "each other player sacrifices a creature of their choice";
    }

    private RampageOfTheValkyriesEffect(RampageOfTheValkyriesEffect effect) {
        super((OneShotEffect)effect);
    }

    public RampageOfTheValkyriesEffect copy() {
        return new RampageOfTheValkyriesEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ArrayList<UUID> perms = new ArrayList<UUID>();
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
            Player player = game.getPlayer(playerId);
            if (player == null || player.getId().equals(source.getControllerId())) continue;
            TargetControlledCreaturePermanent target = new TargetControlledCreaturePermanent();
            target.withNotTarget(true);
            if (!target.canChoose(playerId, source, game)) continue;
            player.choose(this.outcome, (Target)target, source, game);
            perms.add(target.getFirstTarget());
        }
        for (UUID permID : perms) {
            Permanent permanent = game.getPermanent(permID);
            if (permanent == null) continue;
            permanent.sacrifice(source, game);
        }
        return true;
    }
}

