/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RampagingGeodermEffect
extends OneShotEffect {
    RampagingGeodermEffect() {
        super(Outcome.Benefit);
        this.staticText = "target attacking creature gets +1/+1 until end of turn. If it's attacking a battle, put a +1/+1 counter on it instead";
    }

    private RampagingGeodermEffect(RampagingGeodermEffect effect) {
        super((OneShotEffect)effect);
    }

    public RampagingGeodermEffect copy() {
        return new RampagingGeodermEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        Permanent defender = game.getPermanent(game.getCombat().getDefenderId(permanent.getId()));
        if (defender != null && defender.isBattle(game)) {
            return permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        game.addEffect(new BoostTargetEffect(1, 1).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        return true;
    }
}

