/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BecomesCreatureTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.abilities.keyword.ReachAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.Token;
import mage.game.permanent.token.custom.CreatureToken;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RampagingGrowthEffect
extends OneShotEffect {
    RampagingGrowthEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for a basic land card, put it on the battlefield, then shuffle. Until end of turn, that land becomes a 4/3 Insect creature with reach and haste. It's still a land";
    }

    private RampagingGrowthEffect(RampagingGrowthEffect effect) {
        super((OneShotEffect)effect);
    }

    public RampagingGrowthEffect copy() {
        return new RampagingGrowthEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary((FilterCard)StaticFilters.FILTER_CARD_BASIC_LAND_A);
        player.searchLibrary(target, source, game);
        Card card = player.getLibrary().getCard(target.getTargetController(), game);
        if (card == null) {
            player.shuffleLibrary(source, game);
            return true;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent != null) {
            game.addEffect(new BecomesCreatureTargetEffect((Token)new CreatureToken(4, 3, "", new SubType[]{SubType.INSECT}).withAbility((Ability)ReachAbility.getInstance()).withAbility((Ability)HasteAbility.getInstance()), false, true, Duration.EndOfTurn).withDurationRuleAtStart(true).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)), source);
        }
        player.shuffleLibrary(source, game);
        return true;
    }
}

