/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageItem;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;

class RampantRejuvenatorEffect
extends OneShotEffect {
    RampantRejuvenatorEffect() {
        super(Outcome.Benefit);
        this.staticText = "search your library for up to X basic land cards, where X is {this}'s power, put them onto the battlefield, then shuffle";
    }

    private RampantRejuvenatorEffect(RampantRejuvenatorEffect effect) {
        super((OneShotEffect)effect);
    }

    public RampantRejuvenatorEffect copy() {
        return new RampantRejuvenatorEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Permanent permanent = source.getSourcePermanentOrLKI(game);
        if (player == null || permanent == null) {
            return false;
        }
        TargetCardInLibrary target = new TargetCardInLibrary(0, permanent.getPower().getValue(), (FilterCard)StaticFilters.FILTER_CARD_BASIC_LANDS);
        player.searchLibrary(target, source, game);
        CardsImpl cards = new CardsImpl();
        player.getLibrary().getCards(game).stream().map(MageItem::getId).filter(target.getTargets()::contains).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards((Cards)cards, Zone.BATTLEFIELD, source, game);
        player.shuffleLibrary(source, game);
        return true;
    }
}

