/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ReturnToBattlefieldUnderOwnerControlTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RangeTrooperEffect
extends OneShotEffect {
    RangeTrooperEffect() {
        super(Outcome.Detriment);
        this.staticText = "exile target creature. Return that creature to the battlefield at the beginning of the next end step";
    }

    private RangeTrooperEffect(RangeTrooperEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        MageObject sourceObject = game.getObject(source);
        if (permanent != null && sourceObject != null && permanent.moveToExile(source.getSourceId(), sourceObject.getIdName(), source, game)) {
            ReturnToBattlefieldUnderOwnerControlTargetEffect effect = new ReturnToBattlefieldUnderOwnerControlTargetEffect(false, false);
            effect.setText("Return that card to the battlefield under its owner's control at the beginning of the next end step");
            effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
            game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)effect), source);
            return true;
        }
        return false;
    }

    public RangeTrooperEffect copy() {
        return new RangeTrooperEffect(this);
    }
}

