/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RatadrabikOfUrborgEffect
extends OneShotEffect {
    RatadrabikOfUrborgEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "create a token that's a copy of that creature, except it's not legendary and it's a 2/2 black Zombie in addition to its other colors and types.";
    }

    private RatadrabikOfUrborgEffect(RatadrabikOfUrborgEffect effect) {
        super((OneShotEffect)effect);
    }

    public RatadrabikOfUrborgEffect copy() {
        return new RatadrabikOfUrborgEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent copyFrom = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (controller == null || copyFrom == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(controller.getId(), null, false, 1, false, false, null, 2, 2, false);
        effect.withAdditionalSubType(SubType.ZOMBIE);
        effect.setIsntLegendary(true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(copyFrom.getId(), game));
        ObjectColor colors = copyFrom.getColor();
        effect.setOnlyColor(colors.union(new ObjectColor("B")));
        effect.apply(game, source);
        return true;
    }
}

