/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RavenousSlimeEffect
extends ReplacementEffectImpl {
    RavenousSlimeEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "If a creature an opponent controls would die, instead exile it and put a number of +1/+1 counters equal to that creature's power on {this}";
    }

    private RavenousSlimeEffect(RavenousSlimeEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RavenousSlimeEffect copy() {
        return new RavenousSlimeEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (((ZoneChangeEvent)event).getFromZone() != Zone.BATTLEFIELD) {
            return false;
        }
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        if (permanent == null) {
            return false;
        }
        int power = permanent.getPower().getValue();
        controller.moveCards((Card)permanent, Zone.EXILED, source, game);
        new AddCountersSourceEffect(CounterType.P1P1.createInstance(power)).apply(game, source);
        return true;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ZONE_CHANGE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
        if (zEvent.getToZone() != Zone.GRAVEYARD) {
            return false;
        }
        Permanent permanent = ((ZoneChangeEvent)event).getTarget();
        if (permanent == null || !game.getOpponents(source.getControllerId()).contains(permanent.getControllerId())) {
            return false;
        }
        if (zEvent.getTarget() != null) {
            return zEvent.getTarget().isCreature(game);
        }
        return permanent.isCreature(game);
    }
}

