/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.EntersBattlefieldTriggeredAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.AttachedToMatchesFilterCondition;
import mage.abilities.decorator.ConditionalContinuousEffect;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.AttachEffect;
import mage.abilities.effects.common.DontUntapInControllersUntapStepEnchantedEffect;
import mage.abilities.effects.common.TapEnchantedEffect;
import mage.abilities.effects.common.continuous.LoseAllAbilitiesAttachedEffect;
import mage.abilities.keyword.EnchantAbility;
import mage.abilities.keyword.FlashAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.AttachmentType;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class RayOfFrost
extends CardImpl {
    private static final FilterPermanent filter = new FilterPermanent("enchanted creature is red");
    private static final Condition condition;

    public RayOfFrost(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{1}{U}");
        this.subtype.add((Object)SubType.AURA);
        this.addAbility((Ability)FlashAbility.getInstance());
        TargetCreaturePermanent auraTarget = new TargetCreaturePermanent();
        this.getSpellAbility().addTarget((Target)auraTarget);
        this.getSpellAbility().addEffect((Effect)new AttachEffect(Outcome.Removal));
        EnchantAbility ability = new EnchantAbility((Target)auraTarget);
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new EntersBattlefieldTriggeredAbility((Effect)new TapEnchantedEffect().setText("tap it")).withInterveningIf(condition));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new ConditionalContinuousEffect((ContinuousEffect)new LoseAllAbilitiesAttachedEffect(AttachmentType.AURA), condition, "as long as enchanted creature is red, it loses all abilities")));
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new DontUntapInControllersUntapStepEnchantedEffect()));
    }

    private RayOfFrost(RayOfFrost card) {
        super((CardImpl)card);
    }

    public RayOfFrost copy() {
        return new RayOfFrost(this);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.RED));
        condition = new AttachedToMatchesFilterCondition(filter);
    }
}

