/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RazorRingsEffect
extends OneShotEffect {
    RazorRingsEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 4 damage to target attacking or blocking creature. You gain life equal to the excess damage dealt this way";
    }

    private RazorRingsEffect(RazorRingsEffect effect) {
        super((OneShotEffect)effect);
    }

    public RazorRingsEffect copy() {
        return new RazorRingsEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) {
            return false;
        }
        int excess = permanent.damageWithExcess(4, source, game);
        if (excess > 0) {
            Optional.ofNullable(source).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).ifPresent(player -> player.gainLife(excess, game, source));
        }
        return true;
    }
}

