/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.Effect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RazorfieldRipperTriggeredAbility
extends TriggeredAbilityImpl {
    RazorfieldRipperTriggeredAbility(Effect effect) {
        super(Zone.BATTLEFIELD, effect);
        this.setTriggerPhrase("Whenever {this} or equipped creature attacks, ");
    }

    private RazorfieldRipperTriggeredAbility(RazorfieldRipperTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public RazorfieldRipperTriggeredAbility copy() {
        return new RazorfieldRipperTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DECLARED_ATTACKERS;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        UUID attacker = !game.getCombat().getAttackers().contains(this.getSourceId()) ? ((permanent = this.getSourcePermanentOrLKI(game)) != null && game.getCombat().getAttackers().contains(permanent.getAttachedTo()) ? permanent.getAttachedTo() : null) : this.getSourceId();
        if (attacker == null) {
            return false;
        }
        this.getEffects().setTargetPointer((TargetPointer)new FixedTarget(attacker, game));
        return true;
    }
}

