/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.MageInt;
import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.common.SimpleActivatedAbility;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.CantBeTargetedSourceEffect;
import mage.abilities.effects.common.PutOnLibraryTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.SubType;
import mage.filter.FilterObject;
import mage.filter.FilterPermanent;
import mage.filter.FilterStackObject;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class RebelInformer
extends CardImpl {
    private static final FilterObject filterWhite = new FilterStackObject("white spells or abilities from white sources");
    private static final FilterPermanent filterRebel = new FilterPermanent("nontoken Rebel");

    public RebelInformer(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.CREATURE}, "{2}{B}");
        this.subtype.add((Object)SubType.HUMAN);
        this.subtype.add((Object)SubType.MERCENARY);
        this.subtype.add((Object)SubType.REBEL);
        this.power = new MageInt(1);
        this.toughness = new MageInt(2);
        this.addAbility((Ability)new SimpleStaticAbility((Effect)new CantBeTargetedSourceEffect(filterWhite, Duration.WhileOnBattlefield)));
        SimpleActivatedAbility ability = new SimpleActivatedAbility((Effect)new PutOnLibraryTargetEffect(false), (Cost)new GenericManaCost(3));
        ability.addTarget((Target)new TargetPermanent(filterRebel));
        this.addAbility((Ability)ability);
    }

    private RebelInformer(RebelInformer card) {
        super((CardImpl)card);
    }

    public RebelInformer copy() {
        return new RebelInformer(this);
    }

    static {
        filterWhite.add((Predicate)new ColorPredicate(ObjectColor.WHITE));
        filterRebel.add((Predicate)TokenPredicate.FALSE);
        filterRebel.add((Predicate)SubType.REBEL.getPredicate());
    }
}

