/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInYourGraveyard;
import mage.util.CardUtil;

class RecallEffect
extends OneShotEffect {
    RecallEffect() {
        super(Outcome.ReturnToHand);
        this.staticText = "Discard X cards, then return a card from your graveyard to your hand for each card discarded this way";
    }

    private RecallEffect(RecallEffect effect) {
        super((OneShotEffect)effect);
    }

    public RecallEffect copy() {
        return new RecallEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Cards cardsDiscarded = controller.discard(((Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0)).intValue(), false, false, source, game);
            if (!cardsDiscarded.isEmpty()) {
                TargetCardInYourGraveyard target = new TargetCardInYourGraveyard(cardsDiscarded.size(), new FilterCard());
                target.withNotTarget(true);
                target.choose(Outcome.ReturnToHand, controller.getId(), source.getSourceId(), source, game);
                controller.moveCards((Cards)new CardsImpl((Collection)target.getTargets()), Zone.HAND, source, game);
            }
            return true;
        }
        return false;
    }
}

