/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class RecoilEffect
extends OneShotEffect {
    RecoilEffect() {
        super(Outcome.Detriment);
        this.staticText = "return target permanent to its owner's hand. Then that player discards a card";
    }

    private RecoilEffect(RecoilEffect effect) {
        super((OneShotEffect)effect);
    }

    public RecoilEffect copy() {
        return new RecoilEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent target = game.getPermanent(source.getFirstTarget());
        if (target == null) {
            return false;
        }
        Player controller = game.getPlayer(target.getControllerId());
        if (controller != null) {
            controller.moveCards((Card)target, Zone.HAND, source, game);
            controller.discard(1, false, false, source, game);
            return true;
        }
        return false;
    }
}

