/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class RecommissionCounterEffect
extends ReplacementEffectImpl {
    RecommissionCounterEffect() {
        super(Duration.EndOfStep, Outcome.BoostCreature);
    }

    private RecommissionCounterEffect(RecommissionCounterEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public RecommissionCounterEffect copy() {
        return new RecommissionCounterEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        return this.getTargetPointer().getTargets(game, source).contains(event.getTargetId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent permanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (permanent == null || !permanent.isCreature(game)) {
            return false;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(), source.getControllerId(), source, game, event.getAppliedEffects());
        this.discard();
        return false;
    }
}

