/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RecurringInsightEffect
extends OneShotEffect {
    RecurringInsightEffect() {
        super(Outcome.DrawCard);
        this.staticText = "Draw cards equal to the number of cards in target opponent's hand";
    }

    private RecurringInsightEffect(RecurringInsightEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
            if (opponent != null) {
                controller.drawCards(opponent.getHand().size(), source, game);
            }
            return true;
        }
        return false;
    }

    public RecurringInsightEffect copy() {
        return new RecurringInsightEffect(this);
    }
}

