/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.common.delayed.AtTheBeginOfNextEndStepDelayedTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.ExileTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class RedSunsTwilightEffect
extends OneShotEffect {
    RedSunsTwilightEffect() {
        super(Outcome.Benefit);
        this.staticText = "Destroy up to X target artifacts. If X is 5 or more, for each artifact destroyed this way, create a token that's a copy of it. Those tokens gain haste. Exile them at the beginning of the next end step.";
    }

    private RedSunsTwilightEffect(RedSunsTwilightEffect effect) {
        super((OneShotEffect)effect);
    }

    public RedSunsTwilightEffect copy() {
        return new RedSunsTwilightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        int xValue = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        ArrayList<Permanent> destroyedArtifacts = new ArrayList<Permanent>();
        for (Object targetID : this.getTargetPointer().getTargets(game, source)) {
            Permanent permanent = game.getPermanent((UUID)targetID);
            if (permanent == null || !permanent.destroy(source, game, false)) continue;
            game.processAction();
            destroyedArtifacts.add(permanent);
        }
        if (xValue < 5) {
            return true;
        }
        ArrayList tokens = new ArrayList();
        for (Permanent destoyedArtifact : destroyedArtifacts) {
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(player.getId(), null, true);
            effect.setSavedPermanent(destoyedArtifact);
            effect.apply(game, source);
            tokens.addAll(effect.getAddedPermanents());
        }
        ExileTargetEffect exileEffect = new ExileTargetEffect();
        exileEffect.setTargetPointer((TargetPointer)new FixedTargets(tokens, game));
        exileEffect.setText("exile tokens created with {this}");
        game.addDelayedTriggeredAbility((DelayedTriggeredAbility)new AtTheBeginOfNextEndStepDelayedTriggeredAbility((Effect)exileEffect), source);
        return true;
    }
}

