/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.ArrayList;
import java.util.List;
import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.SourcePermanentPowerValue;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.builder.ConditionalManaBuilder;
import mage.abilities.mana.builder.common.ActivatedAbilityManaBuilder;
import mage.choices.Choice;
import mage.choices.ChoiceColor;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;

class RedshiftRocketeerChiefManaEffect
extends ManaEffect {
    private final ConditionalManaBuilder manaBuilder = new ActivatedAbilityManaBuilder();

    RedshiftRocketeerChiefManaEffect() {
        this.staticText = "Add X mana of any one color, where X is {this}'s power. " + this.manaBuilder.getRule();
    }

    private RedshiftRocketeerChiefManaEffect(RedshiftRocketeerChiefManaEffect effect) {
        super((ManaEffect)effect);
    }

    public List<Mana> getNetMana(Game game, Ability source) {
        ArrayList<Mana> netMana = new ArrayList<Mana>();
        if (game == null) {
            return netMana;
        }
        int currentPower = SourcePermanentPowerValue.NOT_NEGATIVE.calculate(game, source, null);
        netMana.add((Mana)this.manaBuilder.setMana(Mana.BlackMana((int)currentPower), source, game).build(new Object[0]));
        netMana.add((Mana)this.manaBuilder.setMana(Mana.BlueMana((int)currentPower), source, game).build(new Object[0]));
        netMana.add((Mana)this.manaBuilder.setMana(Mana.RedMana((int)currentPower), source, game).build(new Object[0]));
        netMana.add((Mana)this.manaBuilder.setMana(Mana.GreenMana((int)currentPower), source, game).build(new Object[0]));
        netMana.add((Mana)this.manaBuilder.setMana(Mana.WhiteMana((int)currentPower), source, game).build(new Object[0]));
        return netMana;
    }

    public Mana produceMana(Game game, Ability source) {
        Mana mana = new Mana();
        if (game == null) {
            return mana;
        }
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return mana;
        }
        ChoiceColor choice = new ChoiceColor();
        if (!controller.choose(Outcome.PutManaInPool, (Choice)choice, game)) {
            return mana;
        }
        Mana chosen = choice.getMana(SourcePermanentPowerValue.NOT_NEGATIVE.calculate(game, source, null));
        return (Mana)this.manaBuilder.setMana(chosen, source, game).build(new Object[0]);
    }

    public RedshiftRocketeerChiefManaEffect copy() {
        return new RedshiftRocketeerChiefManaEffect(this);
    }
}

