/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.RedirectionEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;
import mage.target.TargetPlayer;
import mage.target.TargetSource;

class ReflectDamageEffect
extends RedirectionEffect {
    private final TargetSource damageSource;

    ReflectDamageEffect() {
        super(Duration.EndOfTurn, Integer.MAX_VALUE, RedirectionEffect.UsageType.ONE_USAGE_ABSOLUTE);
        this.staticText = "The next time a source of your choice would deal damage this turn, that damage is dealt to that source's controller instead";
        this.damageSource = new TargetSource();
    }

    private ReflectDamageEffect(ReflectDamageEffect effect) {
        super((RedirectionEffect)effect);
        this.damageSource = effect.damageSource.copy();
    }

    public ReflectDamageEffect copy() {
        return new ReflectDamageEffect(this);
    }

    public void init(Ability source, Game game) {
        super.init(source, game);
        this.damageSource.choose(Outcome.PreventDamage, source.getControllerId(), source.getSourceId(), source, game);
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        MageObject object = game.getObject(event.getSourceId());
        if (object instanceof Spell && ((Spell)object).getSourceId().equals(this.damageSource.getFirstTarget())) {
            TargetPlayer target = new TargetPlayer();
            target.add(((Spell)object).getControllerId(), game);
            this.redirectTarget = target;
            return true;
        }
        if (object instanceof Controllable && object.getId().equals(this.damageSource.getFirstTarget())) {
            TargetPlayer target = new TargetPlayer();
            target.add(((Controllable)object).getControllerId(), game);
            this.redirectTarget = target;
            return true;
        }
        return false;
    }
}

