/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class ReflectionOfKikiJikiEffect
extends OneShotEffect {
    ReflectionOfKikiJikiEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of another target nonlegendary creature you control, except it has haste. Sacrifice it at the beginning of the next end step";
    }

    private ReflectionOfKikiJikiEffect(ReflectionOfKikiJikiEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReflectionOfKikiJikiEffect copy() {
        return new ReflectionOfKikiJikiEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, true);
        effect.setTargetPointer((TargetPointer)new FixedTarget(source.getFirstTarget(), game));
        effect.apply(game, source);
        effect.sacrificeTokensCreatedAtNextEndStep(game, source);
        return true;
    }
}

