/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.r.ExclusionRitualReplacementEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class ReflectorMageEffect
extends OneShotEffect {
    ReflectorMageEffect() {
        super(Outcome.Benefit);
        this.staticText = "return target creature an opponent controls to its owner's hand. That creature's owner can't cast spells with the same name as that creature until your next turn";
    }

    private ReflectorMageEffect(ReflectorMageEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReflectorMageEffect copy() {
        return new ReflectorMageEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            Permanent targetCreature = game.getPermanent(this.getTargetPointer().getFirst(game, source));
            if (targetCreature != null) {
                controller.moveCards((Card)targetCreature, Zone.HAND, source, game);
                if (!CardUtil.haveEmptyName((MageObject)targetCreature)) {
                    game.addEffect((ContinuousEffect)new ExclusionRitualReplacementEffect(targetCreature.getName(), targetCreature.getOwnerId()), source);
                }
            }
            return true;
        }
        return false;
    }
}

