/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostTargetEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RegentsAuthorityEffect
extends OneShotEffect {
    RegentsAuthorityEffect() {
        super(Outcome.Benefit);
        this.staticText = "target creature gets +2/+2 until end of turn. If it's an enchantment creature or legendary creature, instead put a +1/+1 counter on it and it gets +1/+1 until end of turn";
    }

    private RegentsAuthorityEffect(RegentsAuthorityEffect effect) {
        super((OneShotEffect)effect);
    }

    public RegentsAuthorityEffect copy() {
        return new RegentsAuthorityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        if (!(permanent.isEnchantment(game) || permanent.isCreature(game) && permanent.isLegendary(game))) {
            game.addEffect((ContinuousEffect)new BoostTargetEffect(2, 2), source);
            return true;
        }
        permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        game.addEffect((ContinuousEffect)new BoostTargetEffect(1, 1), source);
        return true;
    }
}

