/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.SharesCreatureTypePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ReinsOfTheVinesteedEffect
extends OneShotEffect {
    ReinsOfTheVinesteedEffect() {
        super(Outcome.PutCardInPlay);
        this.staticText = "you may return {this} from your graveyard to the battlefield attached to a creature that shares a creature type with that creature";
    }

    private ReinsOfTheVinesteedEffect(ReinsOfTheVinesteedEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Card aura = game.getCard(source.getSourceId());
        if (aura != null && game.getState().getZone(aura.getId()) == Zone.GRAVEYARD) {
            Permanent targetPermanent;
            Player controller = game.getPlayer(source.getControllerId());
            Permanent lastStateAura = (Permanent)game.getLastKnownInformation(aura.getId(), Zone.BATTLEFIELD);
            Permanent lastStateCreature = game.getPermanentOrLKIBattlefield(lastStateAura.getAttachedTo());
            if (lastStateCreature == null) {
                return false;
            }
            FilterCreaturePermanent FILTER = new FilterCreaturePermanent("creature that shares a creature type with " + lastStateCreature.getName());
            FILTER.add((Predicate)new SharesCreatureTypePredicate(lastStateCreature));
            TargetPermanent target = new TargetPermanent((FilterPermanent)FILTER);
            target.withNotTarget(true);
            if (controller != null && controller.choose(Outcome.PutCardInPlay, (Target)target, source, game) && !(targetPermanent = game.getPermanent(target.getFirstTarget())).cantBeAttachedBy((MageObject)aura, source, game, false)) {
                game.getState().setValue("attachTo:" + aura.getId(), (Object)targetPermanent);
                controller.moveCards(aura, Zone.BATTLEFIELD, source, game);
                return targetPermanent.addAttachment(aura.getId(), source, game);
            }
        }
        return false;
    }

    public ReinsOfTheVinesteedEffect copy() {
        return new ReinsOfTheVinesteedEffect(this);
    }
}

