/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.util.CardUtil;

class ReinterpretEffect
extends OneShotEffect {
    ReinterpretEffect() {
        super(Outcome.Benefit);
        this.staticText = "counter target spell. You may cast a spell with an equal or lesser mana value from your hand without paying its mana cost";
    }

    private ReinterpretEffect(ReinterpretEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReinterpretEffect copy() {
        return new ReinterpretEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Spell spell = game.getSpell(source.getFirstTarget());
        Player controller = game.getPlayer(source.getControllerId());
        if (spell == null || controller == null) {
            return false;
        }
        int manaValue = spell.getManaValue();
        game.getStack().counter(spell.getId(), source, game);
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, manaValue + 1));
        CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)controller.getHand(), (FilterCard)filter);
        return true;
    }
}

