/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.combat.GoadTargetEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.token.Black22BirdToken;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RendmawCreakingNestEffect
extends OneShotEffect {
    RendmawCreakingNestEffect() {
        super(Outcome.Benefit);
        this.staticText = "each player creates a tapped 2/2 black Bird creature token with flying. The tokens are goaded for the rest of the game";
    }

    private RendmawCreakingNestEffect(RendmawCreakingNestEffect effect) {
        super((OneShotEffect)effect);
    }

    public RendmawCreakingNestEffect copy() {
        return new RendmawCreakingNestEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game, true)) {
            Black22BirdToken token = new Black22BirdToken();
            token.putOntoBattlefield(1, game, source, playerId, true, false);
            token.getLastAddedTokenIds().forEach(id -> game.addEffect(new GoadTargetEffect().setDuration(Duration.EndOfGame).setTargetPointer((TargetPointer)new FixedTarget(id, game)), source));
        }
        return true;
    }
}

