/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.util.functions.CopyApplier;
import mage.util.functions.EmptyCopyApplier;

class RenegadeDoppelgangerEffect
extends OneShotEffect {
    RenegadeDoppelgangerEffect() {
        super(Outcome.Benefit);
        this.staticText = "have {this} become a copy of that creature until end of turn";
    }

    private RenegadeDoppelgangerEffect(RenegadeDoppelgangerEffect effect) {
        super((OneShotEffect)effect);
    }

    public RenegadeDoppelgangerEffect copy() {
        return new RenegadeDoppelgangerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getSourceId());
        Permanent targetCreature = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        if (targetCreature == null || permanent == null) {
            return false;
        }
        game.copyPermanent(Duration.EndOfTurn, targetCreature, permanent.getId(), source, (CopyApplier)new EmptyCopyApplier());
        return false;
    }
}

