/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.game.Game;
import mage.players.Player;

class RenegadeReaperEffect
extends OneShotEffect {
    RenegadeReaperEffect() {
        super(Outcome.Benefit);
        this.staticText = "mill four cards. If at least one Angel card is milled this way, you gain 4 life";
    }

    private RenegadeReaperEffect(RenegadeReaperEffect effect) {
        super((OneShotEffect)effect);
    }

    public RenegadeReaperEffect copy() {
        return new RenegadeReaperEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        if (player.millCards(4, source, game).getCards(game).stream().anyMatch(card -> card.hasSubtype(SubType.ANGEL, game))) {
            player.gainLife(4, game, source);
        }
        return true;
    }
}

