/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.ChooseCreatureTypeEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.EnteredThisTurnPredicate;
import mage.filter.predicate.permanent.TokenPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class RenewedSolidarityEffect
extends OneShotEffect {
    private static final FilterControlledPermanent filter = new FilterControlledPermanent();

    public RenewedSolidarityEffect() {
        super(Outcome.Benefit);
        this.staticText = "for each token you control of the chosen type that entered this turn, create a token that's a copy of it";
    }

    public RenewedSolidarityEffect(RenewedSolidarityEffect effect) {
        super((OneShotEffect)effect);
    }

    public RenewedSolidarityEffect copy() {
        return new RenewedSolidarityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        SubType subType = ChooseCreatureTypeEffect.getChosenCreatureType((UUID)source.getSourceId(), (Game)game);
        List tokens = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), source, game).stream().filter(permanent -> permanent.hasSubtype(subType, game)).collect(Collectors.toList());
        boolean result = false;
        for (Permanent token : tokens) {
            result |= new CreateTokenCopyTargetEffect().setTargetPointer((TargetPointer)new FixedTarget(token, game)).apply(game, source);
        }
        return result;
    }

    static {
        filter.add((Predicate)TokenPredicate.TRUE);
        filter.add((Predicate)EnteredThisTurnPredicate.instance);
    }
}

