/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class RenoAndRudeEffect
extends OneShotEffect {
    RenoAndRudeEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of that player's library. Then you may sacrifice another creature or artifact. If you do, you may play the exiled card this turn, and mana of any type can be spent to cast it";
    }

    private RenoAndRudeEffect(RenoAndRudeEffect effect) {
        super((OneShotEffect)effect);
    }

    public RenoAndRudeEffect copy() {
        return new RenoAndRudeEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Card card = Optional.ofNullable(this.getTargetPointer().getFirst(game, source)).map(arg_0 -> ((Game)game).getPlayer(arg_0)).map(Player::getLibrary).map(library -> library.getFromTop(game)).orElse(null);
        SacrificeTargetCost cost = new SacrificeTargetCost((FilterPermanent)StaticFilters.FILTER_CONTROLLED_ARTIFACT_OR_OTHER_CREATURE);
        if (card == null) {
            return cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(Outcome.DrawCard, "Sacrifice another creature or artifact?", source, game) && cost.pay(source, game, source, player.getId(), true);
        }
        player.moveCards(card, Zone.EXILED, source, game);
        if (cost.canPay(source, source, source.getControllerId(), game) && player.chooseUse(Outcome.DrawCard, "Sacrifice another creature or artifact?", source, game) && cost.pay(source, game, source, player.getId(), true)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.EndOfTurn, (boolean)true);
        }
        return true;
    }
}

