/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RepeatOffenderEffect
extends OneShotEffect {
    RepeatOffenderEffect() {
        super(Outcome.Benefit);
        this.staticText = "if {this} is suspected, put a +1/+1 counter on it. Otherwise, suspect it";
    }

    private RepeatOffenderEffect(RepeatOffenderEffect effect) {
        super((OneShotEffect)effect);
    }

    public RepeatOffenderEffect copy() {
        return new RepeatOffenderEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = source.getSourcePermanentIfItStillExists(game);
        if (permanent == null) {
            return false;
        }
        if (permanent.isSuspected()) {
            return permanent.addCounters(CounterType.P1P1.createInstance(), source, game);
        }
        permanent.setSuspected(true, game, source);
        return true;
    }
}

