/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;

class RequiemMonolithEffect
extends OneShotEffect {
    RequiemMonolithEffect() {
        super(Outcome.Benefit);
        this.staticText = "That creature's controller may have {this} deal 1 damage to it";
    }

    private RequiemMonolithEffect(RequiemMonolithEffect effect) {
        super((OneShotEffect)effect);
    }

    public RequiemMonolithEffect copy() {
        return new RequiemMonolithEffect(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(this.getTargetPointer().getFirst(game, source));
        if (permanent == null) return false;
        if (!Optional.ofNullable(permanent).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(player -> player.chooseUse(Outcome.Neutral, "Have this artifact deal 1 damage to " + permanent.getLogName() + '?', source, game)).filter(x -> permanent.damage(1, source, game) > 0).isPresent()) return false;
        return true;
    }
}

