/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.DelayedTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.SacrificeTargetCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class RescueFromTheUnderworldCreateDelayedTriggeredAbilityEffect
extends OneShotEffect {
    protected DelayedTriggeredAbility ability;

    public RescueFromTheUnderworldCreateDelayedTriggeredAbilityEffect(DelayedTriggeredAbility ability) {
        super(ability.getEffects().getOutcome((Ability)ability));
        this.ability = ability;
        this.staticText = "Return that card and the sacrificed card to the battlefield under your control at the beginning of your next upkeep";
    }

    private RescueFromTheUnderworldCreateDelayedTriggeredAbilityEffect(RescueFromTheUnderworldCreateDelayedTriggeredAbilityEffect effect) {
        super((OneShotEffect)effect);
        this.ability = effect.ability.copy();
    }

    public RescueFromTheUnderworldCreateDelayedTriggeredAbilityEffect copy() {
        return new RescueFromTheUnderworldCreateDelayedTriggeredAbilityEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        DelayedTriggeredAbility delayedAbility = this.ability.copy();
        delayedAbility.getTargets().addAll((Collection)source.getTargets());
        for (Effect effect : delayedAbility.getEffects()) {
            effect.getTargetPointer().init(game, source);
        }
        for (Cost cost : source.getCosts()) {
            if (!(cost instanceof SacrificeTargetCost)) continue;
            SacrificeTargetCost sacCost = (SacrificeTargetCost)cost;
            TargetCardInGraveyard target = new TargetCardInGraveyard();
            for (Permanent permanent : sacCost.getPermanents()) {
                target.add(permanent.getId(), game);
                delayedAbility.getTargets().add((Target)target);
            }
        }
        game.addDelayedTriggeredAbility(delayedAbility, source);
        return true;
    }
}

