/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.TappedPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.token.FishToken;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

class ReservoirKrakenEffect
extends OneShotEffect {
    private static final FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("untapped creature you control");

    public ReservoirKrakenEffect() {
        super(Outcome.Tap);
        this.staticText = "any opponent may tap an untapped creature they control. If they do, tap {this} and create a 1/1 blue Fish creature token with \"This token can't be blocked.\"";
    }

    private ReservoirKrakenEffect(ReservoirKrakenEffect effect) {
        super((OneShotEffect)effect);
    }

    public ReservoirKrakenEffect copy() {
        return new ReservoirKrakenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        boolean opponentTapped = false;
        for (UUID opponentId : game.getOpponents(source.getControllerId())) {
            Player opponent = game.getPlayer(opponentId);
            if (opponent == null) continue;
            TargetPermanent target = new TargetPermanent((FilterPermanent)StaticFilters.FILTER_CONTROLLED_UNTAPPED_CREATURE);
            target.withNotTarget(true);
            if (!target.canChoose(opponentId, source, game) || !opponent.chooseUse(Outcome.AIDontUseIt, "Tap an untapped creature you control?", source, game)) continue;
            opponent.chooseTarget(Outcome.Tap, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null || !permanent.tap(source, game)) continue;
            opponentTapped = true;
        }
        if (opponentTapped) {
            Permanent kraken = source.getSourcePermanentIfItStillExists(game);
            if (kraken != null) {
                kraken.tap(source, game);
            }
            new FishToken().putOntoBattlefield(1, game, source);
        }
        return true;
    }

    static {
        filter.add((Predicate)TappedPredicate.UNTAPPED);
    }
}

