/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateRoleAttachedTargetEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.RoleType;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class ReturnTriumphantAbility
extends OneShotEffect {
    ReturnTriumphantAbility() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "return target creature card with mana value 3 or less from your graveyard to the battlefield. Create a Young Hero Role token attached to it";
    }

    private ReturnTriumphantAbility(ReturnTriumphantAbility effect) {
        super((OneShotEffect)effect);
    }

    public ReturnTriumphantAbility copy() {
        return new ReturnTriumphantAbility(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        Card card = game.getCard(source.getFirstTarget());
        if (player == null || card == null) {
            return false;
        }
        player.moveCards(card, Zone.BATTLEFIELD, source, game);
        Permanent permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game);
        if (permanent == null) {
            return false;
        }
        return new CreateRoleAttachedTargetEffect(RoleType.YOUNG_HERO).setTargetPointer((TargetPointer)new FixedTarget(permanent, game)).apply(game, source);
    }
}

