/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.r;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mage.constants.WatcherScope;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.watchers.Watcher;

class ReversePolarityWatcher
extends Watcher {
    private final Map<UUID, Integer> artifactDamageReceivedThisTurn = new HashMap<UUID, Integer>();

    public ReversePolarityWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        Permanent permanent;
        UUID playerId;
        if (event.getType() == GameEvent.EventType.DAMAGED_PLAYER && (playerId = event.getTargetId()) != null && (permanent = game.getPermanent(event.getSourceId())) != null && permanent.isArtifact(game)) {
            this.artifactDamageReceivedThisTurn.putIfAbsent(playerId, 0);
            this.artifactDamageReceivedThisTurn.compute(playerId, (k, v) -> v + event.getAmount());
        }
    }

    public int getArtifactDamageReceivedThisTurn(UUID playerId) {
        return this.artifactDamageReceivedThisTurn.getOrDefault(playerId, 0);
    }

    public void reset() {
        this.artifactDamageReceivedThisTurn.clear();
    }
}

